﻿using gov.va.med.vbecs.BOL;
using System.Collections.Generic;

namespace WPF.PresentationLayer.UC115.Events
{
    /// <summary>
    /// PendingTestReviewedEvent - fired when a pending test is either accepted or rejected
    /// </summary>
    public class PendingTestReviewedEvent
    {
        /// <summary>
        /// PendingTestList
        /// </summary>
        public IEnumerable<IPendingTestModel> PendingTestList { get; private set; }
        /// <summary>
        /// Accepted
        /// </summary>
        public bool Accepted { get; private set; }

        /// <summary>
        /// PendingTestReviewedEvent - constructor
        /// </summary>
        /// <param name="pendingTestList"></param>
        /// <param name="accepted"></param>
        public PendingTestReviewedEvent(IEnumerable<IPendingTestModel> pendingTestList, bool accepted)
        {
            PendingTestList = pendingTestList;
            Accepted = accepted;
        }
    }
}
